class Tower_Nali extends Tower;

simulated function Tick(float DT) 
{
	Super.Tick(DT);
}

state TacticalMove
{
ignores SeePlayer, HearNoise;

	function FireAtEnemy()
	{
	local Pawn P;
	local float ClosestOne,ClosestTwo;
	local Pawn Target;
	local float Range;
	local PBPRI PRI;

	PRI = PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo);
	
	//if ( PRI.WarlordLevel == 0 )
	Range = 250;
	
	Target = None;
	
	for ( P=Level.PawnList; P!=None; P=P.nextPawn )
		{
		if ( P.IsA('Balloon') && !P.IsA('Balloon_Zeppelin') && !Balloon(P).bFrozen )
			{
			if ( Balloon(P).bCamo && !PBPRI(TowerOwner.PlayerReplicationInfo).bHasCamoDetection)
				{
				//Player doesn't have camo detection na na na naaaaa naaaa :-P
				}
			else
				{
				if ( Vsize(P.Location - Location) < Range )
					{
					if ( Vsize(P.Location - Location) < ClosestOne || ClosestOne == 0 )
						{
						ClosestOne = Vsize(P.Location - Location);
						Target = P;
						}
					}
				}
			}
		}
	if ( Target != None )
		{
		Shoot(Target);
		Enemy = Target;
		MyTarget = Target;
		}
	else
		{
		PlayAnim('levitate');
		MyTarget = None;
		}
	}

	function Shoot(Pawn Target)
	{
	local Vector FireSpot, ProjStart;
	local Proj_Tower_Nali p;
	local Rotator FireRotation;
	
	PlaySound(FireSound, SLOT_None,5.0);

	ProjStart = Location;
	//+ FMin(1, 0.7 + 0.6 * FRand()) 
	FireSpot = (Target.Location - Vect(0,0,20)) * (Target.Velocity * VSize(Target.Location - ProjStart)/ProjectileType.Default.Speed);
	//if ( !FastTrace(FireSpot, ProjStart) )
	//		FireSpot = 0.5 * (FireSpot + Target.Location);
	FireRotation = Rotator(Target.Location - Location);
	p = Spawn(Class'Proj_Tower_Nali',TowerOwner,,ProjStart,FireRotation);
	P.Velocity *= 8;
	p.instigator = TowerOwner;
	PlayAnim('Bow2');
	}
}

defaultproperties
{
	 TowerName="Nali Tower"
	 ProjectileType=Class'Proj_Tower_Nali'
	 FireSound=Sound'BotPack.ASMD.Vapour'
	 TimerSpeed(1)=2.0
	 TimerSpeed(2)=2.0
	 TimerSpeed(3)=2.0
	 TimerSpeed(4)=2.0
     DrawType=DT_Mesh
     Mesh=LodMesh'UnrealShare.Nali1'
	 Skin=Texture'UnrealShare.Skins.JNali2'
     TransientSoundVolume=1.500000
     CollisionRadius=25.000000
     CollisionHeight=46.000000
     Mass=140.000000
     Buoyancy=140.000000
	 RotationRate=(Pitch=2048,Yaw=40000,Roll=0
	 DrawScale=0.5
}
